/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.CustomDrawContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ModeSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.systems.setting.settings.shared.PredicateValue;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.game.PotionUtility;
import Krasnodar.rockstarnew.utility.game.TextUtility;
import Krasnodar.rockstarnew.utility.inventory.EnchantmentUtility;
import Krasnodar.rockstarnew.utility.render.Draw3DUtility;
import Krasnodar.rockstarnew.utility.render.DrawUtility;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import Krasnodar.rockstarnew.utility.render.Utils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1686;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1776;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_742;
import net.minecraft.class_7833;

@ModuleInfo(name="Prediction", category=ModuleCategory.VISUALS)
public class Prediction
extends BaseModule {
    private final List<Predicted> predicted = new ArrayList<Predicted>();
    private final List<Landed> landed = new ArrayList<Landed>();
    private final SelectSetting entities = new SelectSetting(this, "modules.settings.prediction.entities");
    private final ModeSetting renderMode = new ModeSetting(this, "modules.settings.prediction.render_mode");
    private final ModeSetting.Value defaultMode = new ModeSetting.Value(this.renderMode, "modules.settings.prediction.render_mode.default");
    private final ModeSetting.Value glowMode = new ModeSetting.Value(this.renderMode, "modules.settings.prediction.render_mode.glow").select();
    private final BooleanSetting inHand = new BooleanSetting(this, "modules.settings.prediction.hand").enable();
    private final BooleanSetting walls = new BooleanSetting(this, "modules.settings.prediction.walls").enable();
    private final BooleanSetting hud = new BooleanSetting(this, "modules.settings.prediction.hud");
    private final EventListener<HudRenderEvent> onRender2D = event -> {
        CustomDrawContext context = event.getContext();
        class_4587 ms = context.method_51448();
        for (Predicted predict : this.predicted) {
            class_1297 patt3$temp;
            class_1676 projectile;
            class_1297 patt2$temp;
            class_1297 selector1$temp;
            class_241 screenPos = Utils.worldToScreen(predict.vectors.getLast());
            if (screenPos == null) continue;
            float x = screenPos.field_1343;
            float y = screenPos.field_1342;
            Font font = Fonts.MEDIUM.getFont(13.0f);
            float height = font.height() + 6.0f;
            float yOff = -height;
            Object name = predict.entity.method_5477().getString().replace("\u0411\u0440\u043e\u0448\u0435\u043d\u043d\u044b\u0439 \u044d\u043d\u0434\u0435\u0440-\u0436\u0435\u043c\u0447\u0443\u0433", "\u042d\u043d\u0434\u0435\u0440-\u0436\u0435\u043c\u0447\u0443\u0433");
            class_1297 patt0$temp = predict.entity;
            if (patt0$temp instanceof class_1686) {
                class_1686 potion = (class_1686)patt0$temp;
                name = potion.method_7495().method_63015().getString();
            }
            name = ((String)name).replace("] ", "").replace("[", "") + String.format(" (%s \u0441\u0435\u043a)", TextUtility.formatNumber((float)predict.ticks / 20.0f));
            Objects.requireNonNull(predict.entity);
            int index$2 = 0;
            class_1799 stack = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3857.class, class_1665.class, class_1542.class}, (Object)selector1$temp, index$2)) {
                case 0 -> {
                    class_3857 item = (class_3857)selector1$temp;
                    yield item.method_7495();
                }
                case 1 -> {
                    class_1665 itemx = (class_1665)selector1$temp;
                    yield itemx.method_54759();
                }
                case 2 -> {
                    class_1542 itemxx = (class_1542)selector1$temp;
                    yield itemxx.method_6983();
                }
                default -> class_1802.field_8107.method_7854();
            };
            float distance = (float)predict.vectors.getLast().method_1022(Prediction.mc.field_1724.method_33571());
            float scale = class_3532.method_15363((float)(1.0f - distance / 20.0f), (float)0.5f, (float)1.0f);
            ms.method_22903();
            ms.method_46416(x, y, 0.0f);
            ms.method_22905(scale, scale, 1.0f);
            float firstWidth = font.width((String)name) + 20.0f;
            context.drawRect(-firstWidth / 2.0f, yOff, firstWidth, height, new ColorRGBA(0.0f, 0.0f, 0.0f, 100.0f));
            context.drawItem(stack, -firstWidth / 2.0f, yOff, 1.0f);
            context.drawText(font, (String)name, -firstWidth / 2.0f + 17.0f, yOff + 3.0f, Colors.WHITE);
            yOff += height;
            class_1297 patt1$temp = predict.entity;
            if (patt1$temp instanceof class_1676 && (patt2$temp = (projectile = (class_1676)patt1$temp).method_24921()) instanceof class_742) {
                class_742 player = (class_742)patt2$temp;
                String owner = "\u041e\u0442 " + (projectile.method_24921() == Prediction.mc.field_1724 ? "\u0412\u0430\u0441" : projectile.method_24921().method_5477().getString());
                float secondWidth = font.width(owner) + 22.0f;
                context.drawRect(-secondWidth / 2.0f, yOff, secondWidth, height, new ColorRGBA(0.0f, 0.0f, 0.0f, 100.0f));
                context.drawHead(player, -secondWidth / 2.0f, yOff, height, BorderRadius.ZERO, Colors.WHITE);
                context.drawText(font, owner, -secondWidth / 2.0f + 19.0f, yOff + 3.0f, Colors.WHITE);
                yOff += height;
            }
            if ((patt3$temp = predict.entity) instanceof class_1686) {
                class_1686 potion = (class_1686)patt3$temp;
                for (class_1293 effect : PotionUtility.effects(potion.method_7495())) {
                    String potionName = ((class_1291)effect.method_5579().comp_349()).method_5560().getString();
                    int amplifier = effect.method_5578();
                    int duration = effect.method_5584();
                    String potionLevel = amplifier > 0 ? " " + (amplifier + 1) : "";
                    String potionTime = this.formatDuration(duration);
                    String fullPotionText = potionName + potionLevel + " (" + potionTime + ")";
                    float potionWidth = font.width(fullPotionText) + 6.0f;
                    context.drawRect(-potionWidth / 2.0f, yOff + 5.0f, potionWidth, height, new ColorRGBA(0.0f, 0.0f, 0.0f, 100.0f));
                    context.drawText(font, fullPotionText, -potionWidth / 2.0f + 3.0f, yOff + 8.0f, ColorRGBA.fromInt(((class_1291)effect.method_5579().comp_349()).method_5556()).withAlpha(255.0f));
                    yOff += height;
                }
            }
            ms.method_22909();
        }
        if (this.hud.isEnabled()) {
            Font fontx = Fonts.MEDIUM.getFont(10.0f);
            float yOffx = 0.0f;
            for (Predicted predictx : this.predicted) {
                if (predictx.collidedEntity != Prediction.mc.field_1724 || predictx.entity instanceof class_1684) continue;
                String namex = predictx.entity.method_5477().getString().replace("\u0411\u0440\u043e\u0448\u0435\u043d\u043d\u044b\u0439 \u044d\u043d\u0434\u0435\u0440-\u0436\u0435\u043c\u0447\u0443\u0433", "\u042d\u043d\u0434\u0435\u0440-\u0436\u0435\u043c\u0447\u0443\u0433") + String.format(" (%s \u0441\u0435\u043a)", TextUtility.formatNumber((float)predictx.ticks / 20.0f));
                context.drawCenteredText(fontx, "\u0412 \u0432\u0430\u0441 \u043b\u0435\u0442\u0438\u0442 " + namex, sr.getScaledWidth() / 2.0f, sr.getScaledHeight() / 2.0f + 20.0f + yOffx, Colors.WHITE);
                yOffx += fontx.height() + 3.0f;
            }
        }
    };
    private final EventListener<Render3DEvent> onRender3D = event -> {
        class_4587 ms = event.getMatrices();
        ms.method_22903();
        RenderUtility.setupRender3D(true);
        RenderUtility.prepareMatrices(ms);
        RenderSystem.enableDepthTest();
        if (this.walls.isEnabled()) {
            RenderSystem.disableDepthTest();
        }
        if (this.defaultMode.isSelected()) {
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 builder = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            for (Predicted predicted : this.predicted) {
                class_243 class_2432 = predicted.vectors.getFirst();
                Draw3DUtility.drawLine(ms, builder, Utils.getInterpolatedPos(predicted.entity, event.getTickDelta()), class_2432, Colors.ACCENT);
                for (class_243 pos : predicted.vectors) {
                    void var6_10;
                    Draw3DUtility.drawLine(ms, builder, (class_243)var6_10, pos, Colors.ACCENT);
                    class_243 class_2433 = pos;
                }
            }
            RenderUtility.buildBuffer(builder);
        } else {
            class_2960 id = Rockstar.id("textures/bloom.png");
            RenderSystem.setShaderTexture((int)0, (class_2960)id);
            RenderSystem.setShader((class_10156)class_10142.field_53880);
            class_287 buffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (Predicted predicted : this.predicted) {
                class_243 prevPos = predicted.vectors.getFirst();
                class_243 entityPos = Utils.getInterpolatedPos(predicted.entity, event.getTickDelta());
                if (entityPos.method_1022(Prediction.mc.field_1724.method_33571()) > 2.0) {
                    for (int i = 0; i < 10; ++i) {
                        float t = (float)i / 10.0f;
                        class_243 interpolatedPos = entityPos.method_1019(prevPos.method_1020(entityPos).method_1021((double)t));
                        this.drawGlow(ms, interpolatedPos, buffer, (float)prevPos.method_1022(entityPos) / 3.0f, 1.0f);
                        this.drawGlow(ms, interpolatedPos, buffer, (float)prevPos.method_1022(entityPos) * 2.0f, 0.05f);
                    }
                }
                for (class_243 pos : predicted.vectors) {
                    if (pos.method_1022(Prediction.mc.field_1724.method_33571()) > 2.0) {
                        for (int i = 0; i < 10; ++i) {
                            float t = (float)i / 10.0f;
                            class_243 interpolatedPos = prevPos.method_1019(pos.method_1020(prevPos).method_1021((double)t));
                            this.drawGlow(ms, interpolatedPos, buffer, (float)pos.method_1022(prevPos) / 3.0f, 1.0f);
                            this.drawGlow(ms, interpolatedPos, buffer, (float)pos.method_1022(prevPos) * 2.0f, 0.05f);
                        }
                    }
                    prevPos = pos;
                }
                float size = 9.0f;
                if (!(predicted.entity instanceof class_1686)) continue;
                ms.method_22903();
                ms.method_61958(predicted.vectors.getLast());
                ms.method_22907(class_7833.field_40713.rotationDegrees(-90.0f));
                DrawUtility.drawImage(ms, buffer, (double)(-size / 2.0f), (double)(-size / 2.0f), 0.0, (double)size, (double)size, Colors.ACCENT.withAlpha(255.0f));
                ms.method_22909();
            }
            RenderUtility.buildBuffer(buffer);
        }
        float size = 1.0f;
        class_2960 id = Rockstar.id("textures/hit.png");
        RenderSystem.setShaderTexture((int)0, (class_2960)id);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 class_2872 = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        for (Landed landed : this.landed) {
            if (landed.collidedEntity != null) continue;
            ms.method_22903();
            ms.method_61958(landed.hitResult.method_17784());
            ms.method_22907(landed.hitResult.method_17780().method_23224());
            ms.method_22907(class_7833.field_40713.rotationDegrees(-90.0f));
            DrawUtility.drawImage(ms, class_2872, (double)(-size / 2.0f), (double)(-size / 2.0f), 0.0, (double)size, (double)size, Colors.ACCENT.withAlpha(255.0f));
            ms.method_22909();
        }
        RenderUtility.buildBuffer(class_2872);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_4184 class_41842 = Prediction.mc.field_1773.method_19418();
        class_243 cameraPos = class_41842.method_19326();
        class_287 quadsBuffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (Landed landedx : this.landed) {
            if (landedx.collidedEntity == null) continue;
            Draw3DUtility.renderFilledBox(ms, quadsBuffer, landedx.collidedEntity.method_5829(), Colors.ACCENT.mulAlpha(0.5f));
        }
        RenderUtility.buildBuffer(quadsBuffer);
        class_287 linesBuffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        for (Landed landedxx : this.landed) {
            if (landedxx.collidedEntity == null) continue;
            Draw3DUtility.renderOutlinedBox(ms, linesBuffer, landedxx.collidedEntity.method_5829(), Colors.ACCENT);
        }
        RenderUtility.buildBuffer(linesBuffer);
        RenderUtility.endRender3D();
        ms.method_22909();
    };

    public Prediction() {
        new PredicateValue<class_1297>(this.entities, "modules.settings.prediction.entities.pearls", entity -> entity instanceof class_1684).select();
        new PredicateValue<class_1297>(this.entities, "modules.settings.prediction.entities.tridents", entity -> entity instanceof class_1685).select();
        new PredicateValue<class_1297>(this.entities, "modules.settings.prediction.entities.snowballs", entity -> entity instanceof class_1680).select();
        new PredicateValue<class_1297>(this.entities, "modules.settings.prediction.entities.arrows", entity -> entity instanceof class_1667).select();
        new PredicateValue<class_1297>(this.entities, "modules.settings.prediction.entities.potions", entity -> entity instanceof class_1686).select();
        new PredicateValue<Object>(this.entities, "modules.settings.prediction.entities.items", entity -> entity instanceof class_1542);
    }

    @Override
    public void tick() {
        this.predicted.clear();
        this.landed.clear();
        ArrayList<class_1667> projectiles = new ArrayList<class_1667>();
        if (this.inHand.isEnabled()) {
            class_1799 handStack = Prediction.mc.field_1724.method_6047();
            class_1684 inHand = null;
            if (handStack.method_7909() instanceof class_1776) {
                inHand = new class_1684((class_1937)Prediction.mc.field_1687, (class_1309)Prediction.mc.field_1724, handStack);
            } else if (handStack.method_7909() instanceof class_1835 && Prediction.mc.field_1724.method_6115()) {
                inHand = new class_1685((class_1937)Prediction.mc.field_1687, (class_1309)Prediction.mc.field_1724, handStack);
            } else if (handStack.method_7909() instanceof class_1753 && Prediction.mc.field_1724.method_6115()) {
                class_1799 arrowStack = new class_1799((class_1935)class_1802.field_8107);
                inHand = new class_1667((class_1937)Prediction.mc.field_1687, (class_1309)Prediction.mc.field_1724, arrowStack, handStack);
            } else if (handStack.method_7909() instanceof class_1764 && class_1764.method_7781((class_1799)handStack)) {
                boolean hasMultishot = EnchantmentUtility.getEnchantmentLevel(handStack, (class_5321<class_1887>)class_1893.field_9108) > 0;
                class_1799 arrowStack = new class_1799((class_1935)class_1802.field_8107);
                if (hasMultishot) {
                    for (int i = 0; i < 3; ++i) {
                        class_1667 arrow = new class_1667((class_1937)Prediction.mc.field_1687, (class_1309)Prediction.mc.field_1724, arrowStack, handStack);
                        projectiles.add(arrow);
                    }
                } else {
                    inHand = new class_1667((class_1937)Prediction.mc.field_1687, (class_1309)Prediction.mc.field_1724, arrowStack, handStack);
                }
            }
            if (inHand instanceof class_1676) {
                class_1676 projectile = (class_1676)inHand;
                float speed = 1.5f;
                if (inHand instanceof class_1685) {
                    speed = 2.5f;
                } else if (inHand instanceof class_1667) {
                    speed = 3.0f;
                }
                this.setVelocity(projectile, (class_1297)Prediction.mc.field_1724, Prediction.mc.field_1724.method_36455(), Prediction.mc.field_1724.method_36454(), 0.0f, speed, 1.0f);
                this.predict((class_1297)projectile, true);
            }
        }
        if (!projectiles.isEmpty()) {
            float speed = 3.15f;
            float spreadAngle = 10.0f;
            for (int i = 0; i < projectiles.size(); ++i) {
                class_1676 projectile = (class_1676)projectiles.get(i);
                float yawOffset = 0.0f;
                if (i == 0) {
                    yawOffset = -spreadAngle;
                } else if (i == 2) {
                    yawOffset = spreadAngle;
                }
                this.setVelocity(projectile, (class_1297)Prediction.mc.field_1724, Prediction.mc.field_1724.method_36455(), Prediction.mc.field_1724.method_36454() + yawOffset, 0.0f, speed, 1.0f);
                this.predict((class_1297)projectile, true);
            }
        }
        for (class_1297 entity : Prediction.mc.field_1687.method_18112()) {
            this.predict(entity, false);
        }
    }

    private void predict(class_1297 entity, boolean inHand) {
        if (this.isValid(entity)) {
            List sortedPlayers;
            class_1676 pearl;
            if (entity instanceof class_1676 && (pearl = (class_1676)entity).method_24921() == null && !(sortedPlayers = Prediction.mc.field_1687.method_18456()).isEmpty()) {
                Collections.sort(sortedPlayers, Comparator.comparingDouble(player -> player.method_5739((class_1297)pearl)));
                pearl.method_7432((class_1297)sortedPlayers.getFirst());
            }
            ArrayList<class_243> positions = new ArrayList<class_243>();
            class_243 lastPos = entity.method_19538();
            class_243 lastMotion = entity.method_18798();
            class_1297 collidedEntity = null;
            int ticks = 0;
            class_3965 blockHitResult = null;
            int i = 0;
            while (i < 150) {
                class_243 motion = this.predictMotion(entity, lastMotion);
                class_243 pos = lastPos.method_1019(motion);
                ticks = i++;
                blockHitResult = Prediction.mc.field_1687.method_17742(new class_3959(lastPos, pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
                class_1297 collided = this.checkEntityCollision(entity, pos);
                if (collided != null) {
                    positions.add(pos);
                    collidedEntity = collided;
                    break;
                }
                if (blockHitResult.method_17783() != class_239.class_240.field_1333) {
                    positions.add(blockHitResult.method_17784());
                    break;
                }
                positions.add(pos);
                lastPos = pos;
                lastMotion = motion;
            }
            if (!positions.isEmpty()) {
                if (inHand) {
                    this.landed.add(new Landed(entity, (class_243)positions.getLast(), ticks, collidedEntity, blockHitResult));
                } else {
                    this.predicted.add(new Predicted(entity, positions, ticks, collidedEntity));
                }
            }
        }
    }

    private void drawGlow(class_4587 ms, class_243 pos, class_287 buffer, float size, float alpha) {
        ms.method_22903();
        ms.method_61958(pos);
        ms.method_22907(Prediction.mc.field_1773.method_19418().method_23767());
        DrawUtility.drawImage(ms, buffer, (double)(-size / 2.0f), (double)(-size / 2.0f), 0.0, (double)size, (double)size, Colors.ACCENT.withAlpha(255.0f * alpha));
        ms.method_22909();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValid(class_1297 entity) {
        boolean valid = false;
        for (SelectSetting.Value selectedValue : this.entities.getSelectedValues()) {
            PredicateValue predicateValue = (PredicateValue)selectedValue;
            if (!predicateValue.predicated(entity)) continue;
            valid = true;
        }
        if (entity instanceof class_1685) {
            class_1685 trident = (class_1685)entity;
            if (trident.field_7649 > 0) {
                return false;
            }
        }
        if (!valid) return false;
        if (Math.abs(entity.method_18798().field_1352 + entity.method_18798().field_1350) > (double)0.01f) return true;
        if (!(Math.abs(entity.method_18798().field_1351) > (double)0.2f)) return false;
        return true;
    }

    private class_1297 checkEntityCollision(class_1297 movingEntity, class_243 predictedPos) {
        class_243 currentPos = movingEntity.method_19538();
        class_243 direction = predictedPos.method_1020(currentPos);
        if (direction.method_1027() == 0.0) {
            return null;
        }
        class_3966 hitResult = class_1675.method_18075((class_1297)movingEntity, (class_243)currentPos, (class_243)predictedPos, (class_238)movingEntity.method_5829().method_18804(direction).method_1014(0.5), entity -> Prediction.mc.field_1724 != entity && entity.method_5805() && !(entity instanceof class_1542) && !(entity instanceof class_1303) && entity != movingEntity, (double)direction.method_1027());
        return hitResult != null ? hitResult.method_17782() : null;
    }

    private void setVelocity(class_1676 entity, double x, double y, double z, float power) {
        class_243 vec3d = this.calculateVelocity(entity, x, y, z, power);
        entity.method_18799(vec3d);
        entity.field_6007 = true;
        double d = vec3d.method_37267();
        entity.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 180.0 / 3.1415927410125732));
        entity.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 180.0 / 3.1415927410125732));
        entity.field_5982 = entity.method_36454();
        entity.field_6004 = entity.method_36455();
    }

    private void setVelocity(class_1676 entity, class_1297 shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.setVelocity(entity, f, g, h, speed);
        class_243 vec3d = shooter.method_60478();
        entity.method_18799(entity.method_18798().method_1031(vec3d.field_1352, shooter.method_24828() ? 0.0 : vec3d.field_1351, vec3d.field_1350));
    }

    private class_243 calculateVelocity(class_1676 entity, double x, double y, double z, float power) {
        return new class_243(x, y, z).method_1029().method_1021((double)power);
    }

    private class_243 predictMotion(class_1297 entity, class_243 motion) {
        return motion.method_1021(0.99).method_1031(0.0, -entity.method_56989(), 0.0);
    }

    private String formatDuration(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        int remainingSeconds = seconds % 60;
        return minutes > 0 ? String.format("%d:%02d", minutes, remainingSeconds) : String.format("0:%02d", remainingSeconds);
    }

    record Landed(class_1297 entity, class_243 pos, int ticks, class_1297 collidedEntity, class_3965 hitResult) {
    }

    record Predicted(class_1297 entity, List<class_243> vectors, int ticks, class_1297 collidedEntity) {
    }
}

